<?php
// Tests that "before/after rendering into" actions are ran for roots operated by UWikiFOrmat.

class Utdrdynamic_Root extends UWikiBaseAction {
  function IsDynamic($format, $params) { return true; }
  function Execute($format, $params) { }
}


  $src = '
%%(mirror)
%%(tdrDynamic; html)
<html>
~%%
%%
';

  $expected = '
<table class="mirror">
<tr>
<td class="source">
<pre>%%(tdrDynamic; html)
&lt;html&gt;
%%</pre>
</td>
<td class="result">
<div class="wackowiki format format-html">
<span class="format-name">html</span>
<!--notypo--><pre class="code"><span style="color: #000080;font-weight:bold;">&lt;html&gt;</span></pre><!--/notypo-->
</div>
</td>
</tr>
</table>
';

  $doc = new UWikiDocument($src);
  $doc->settings = $settings;
  $doc->LoadMarkup('wacko');
  $doc->Parse();
  $got = $doc->ToHTML();

    $got = trim( preg_replace('/(\r?\n)+/u', "\n", $got) );
    $expected = trim( preg_replace('/(\r?\n)+/u', "\n", $expected) );

  TestEquality($got, $expected);
